/*
 * @(#)TableFigure.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.dml.diagram;

import ch.hslu.cm.dml.model.DMLModel;
import ch.hslu.cm.dml.model.SimulatedTable;
import ch.hslu.cm.dml.model.SimulatedTableEvent;
import ch.hslu.cm.dml.model.SimulatedTableListener;
import java.io.IOException;
import org.jhotdraw.draw.*;
import ch.hslu.cm.*;
import ch.hslu.cm.simulation.*;
import ch.hslu.cm.dml.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * TableFigure.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18 Created.
 */
public class TableFigure extends RectangleFigure 
        implements DiagramFigure, SimulatedTableListener {
    private SimulatedTable model;
    
    /** Creates a new instance. */
    public TableFigure() {
    }
    // DRAWING
    // SHAPE AND BOUNDS
    // ATTRIBUTES
    // EDITING
    // CONNECTING
    // COMPOSITE FIGURES
    // CLONING
    // EVENT HANDLING

    public SimulatedTable getSimulatedTable() {
        return (SimulatedTable) getModel();
    }
    
    /**
     * Gets a connector for this figure at the given location.
     * A figure can have different connectors at different locations.
     */
    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }
    
    
    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            MoveHandle.addMoveHandles(this, handles);
        }
        return handles;
    }

    protected SimulatedTable createSimulatedTable() {
        return new SimulatedTable();
    }
    
    public void setModel(SimulatedTable m) {
        willChange();
        if (model != null) {
            model.removeSimulatedTableListener(this);
        }
        model = m;
        if (model != null) {
            model.addSimulatedTableListener(this);
            //((TextFigure) nameCompartment.getChild(0)).setText(model.getName());
            
            //updateAttributeCompartment();
        }
        changed();
    }
    
    @Override
    public SimulatedTable getModel() {
        return model;
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }
    
    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    
    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = DMLModel.labels;
        
        LinkedList<Action> actions = new LinkedList<Action>();
        return actions;
    }
    
    @Override
    public TableFigure clone() {
        TableFigure that = (TableFigure) super.clone();
        that.setModel((SimulatedTable) this.model.clone());
        return that;
    }
    
    
    public SimulatedElement getSimulatedObject() {
        return model;
    }
    
    public int getConnectionCount() {
        return getModel().getRelationships().size();
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return getModel().getRelationships().indexOf(f.getModel());
    }
    
    public void generalizationChanged(SimulatedTableEvent event) {
    }
    
    protected void drawConnectors(Graphics2D g) {
    }
    
    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return new ChopRectangleConnector(this);
    }
    
    @Override
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0d);
        double y = in.getAttribute("y", 0d);
        double w = in.getAttribute("w", 0d);
        double h = in.getAttribute("h", 0d);
        setBounds(new Point2D.Double(x,y), new Point2D.Double(x+w,y+h));
        readAttributes(in);
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((SimulatedTable) in.readObject(0));
        in.closeElement();
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        out.addAttribute("w", r.width);
        out.addAttribute("h", r.height);
        writeAttributes(out);
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
    }
    @Override
    public int getLayer() {
        return DMLDiagram.ENTITY_TYPE_LAYER;
    }
    @Override
    public void tableChanged(SimulatedTableEvent event) {
    }
}
